from pydantic import BaseModel, EmailStr, Field, StringConstraints
from typing import Optional

class UserCreateSchema(BaseModel):
    username: str = Field(..., description="Nome de usuário", example="joaosilva")
    email: EmailStr = Field(..., description="E-mail do usuário", example="joao@exemplo.com")
    password: str = Field(..., description="Senha", example="senha123")
    confirm_password: str = Field(..., description="Confirmação da senha", example="senha123")
    first_name: Optional[str] = Field(None, description="Primeiro nome", example="João")
    last_name: Optional[str] = Field(None, description="Último nome", example="Silva")
    phone: Optional[str] = Field(None, description="Telefone", example="+5511999999999")
    birth_date: Optional[str] = Field(None, description="Data de nascimento (YYYY-MM-DD)", example="1990-05-15")

    class Config:
        schema_extra = {
            "example": {
                "username": "joaosilva",
                "email": "joao@exemplo.com",
                "password": "senha123",
                "confirm_password": "senha123",
                "first_name": "João",
                "last_name": "Silva",
                "phone": "+5511999999999",
                "birth_date": "1990-05-15"
            }
        }
