from pydantic import BaseModel
from typing import Optional, List, Any

class MessageResponse(BaseModel):
    """Schema base para respostas com mensagem"""
    message: str
    request_time: float

class UserCreate(BaseModel):
    """Schema para criação de usuário"""
    username: str
    email: str
    password: str

class UserUpdate(BaseModel):
    """Schema para atualização de usuário"""
    username: Optional[str] = None
    email: Optional[str] = None
    password: Optional[str] = None

class UserResponse(BaseModel):
    """Schema para resposta de usuário"""
    id: int
    username: str
    email: str
    request_time: float = 0.0

class LoginSchema(BaseModel):
    """Schema para login"""
    username: str
    password: str

class TokenResponse(BaseModel):
    """Schema para resposta de token"""
    access_token: str
    request_time: float = 0.0

class PaginatedResponse(BaseModel):
    """Schema para resposta paginada"""
    items: List[Any]
    total: int
    page: int
    per_page: int
    total_pages: int
    request_time: float = 0.0