from flask import Flask
from flask_sqlalchemy import SQLAlchemy
from flask_migrate import Migrate
from flask_cors import CORS
from app.config import Config

db = SQLAlchemy()
migrate = Migrate()

def create_app(config_class=Config):
    app = Flask(__name__)
    app.config.from_object(config_class)

    # Inicialização das extensões
    db.init_app(app)
    migrate.init_app(app, db)
    CORS(app)

    # Registro dos blueprints
    from app.routes import user_bp, auth_bp, category_bp, expense_bp, income_bp, report_bp
    app.register_blueprint(user_bp, url_prefix='/api/users')
    app.register_blueprint(auth_bp, url_prefix='/api/auth')
    app.register_blueprint(category_bp, url_prefix='/api/categories')
    app.register_blueprint(expense_bp, url_prefix='/api/expenses')
    app.register_blueprint(income_bp, url_prefix='/api/incomes')
    app.register_blueprint(report_bp, url_prefix='/api/reports')

    return app
