from typing import Any, List, Optional
from pydantic import BaseModel, Field

class ErrorDetail(BaseModel):
    field: str = Field(..., description="Campo com erro")
    message: str = Field(..., description="Mensagem do erro")

class APIResponse(BaseModel):
    status: str = Field(..., description="Status da resposta (success, error)")
    message: str = Field(..., description="Mensagem explicativa")
    code: int = Field(..., description="Código HTTP da resposta")
    data: Optional[Any] = Field(None, description="Dados da resposta")
    errors: Optional[List[ErrorDetail]] = Field(None, description="Lista de erros de validação")

    class Config:
        schema_extra = {
            "example": {
                "status": "success",
                "message": "Usuário criado com sucesso",
                "code": 201,
                "data": {
                    "id": 1,
                    "username": "joaosilva",
                    "email": "joao@exemplo.com"
                },
                "errors": None
            }
        }
